#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Cube patternsMod01.fsh  by scry  
//https://www.shadertoy.com/view/flSSRt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define time iTime
mat2 r2d(float a) {
    return mat2(cos(a),sin(a),-sin(a),cos(a));
}

vec3 opRepLim( in vec3 p, in float c, in vec3 l)
{
    vec3 q = p-c*clamp(round(p/c),-l,l);
    return q;
    //return primitive( q );
}
// All components are in the range [0…1], including hue.
vec3 rgb2hsv(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}
 

// All components are in the range [0…1], including hue.
vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}
//Taken from http://lolengine.net/blog/2013/07/27/rgb-to-hsv-in-glsl.

vec4 map(vec3 p) {
    float pd = 9.;
    //p.z += time*2.1;
    p.z += 0.5;
    float cs = length(p)-0.1;
    p.z -= 0.5;
    p.x += sin(time*0.3)*0.3;
    p.z += sin(time*0.3)*0.4;
    
    p.xz *= r2d(sin(time*.05)*0.5);
    p.yz *= r2d(cos(time*.07)*0.5);
    //vec3 m = p;
    vec3 o = p;
    float c = length(p);
    p = (fract(p*pd)-0.5)/pd;
    p = abs(p);
    
    p.xz *= r2d(sin(time*.05)*20.5);
    
    p.yz *= r2d(cos(time*.07)*0.5);
    
    //float cs = length(p);
    //p.xz *= r2d(sin(time*1.+c*13.));
    //p.xy *= r2d(sin(c*20+time)*0.2);
    //p = (fract(p*pd)-0.5)/pd;
    //p.xz *= r2d(sin(log(c*3.)-time*0.3)*4.);
    p.xy = vec2(length(p.xy),atan(p.x,p.y));
    
    //p.y = abs(p.y);
    //p.y *= 8./3.14159;
    //vec3 m = p;
    p.y *= 4./(3.14159*2.);
    p.y = (fract(p.y)-0.5);
    p.y = abs(p.y)-sin(o.z*0.2);
    
    p.xy = vec2(p.x*sin(p.y),p.x*cos(p.y));
    
    p = opRepLim(p,0.21,vec3(1.));
    p.xz *= r2d(sin(time*1.+c*13.));
    p = opRepLim(p,0.06,vec3(2.));
    p.xy *= r2d(sin(time*1.)+time);
    vec3 m = p;
    p = opRepLim(p,0.005,vec3((0.5-sin(c*5.5+time)*0.5)*10.));

    float d = length(p)-0.001;
    d = max(d,-(length(o.xy)-0.3+o.z*02.1));
    d = max(d,-(cs));
    return vec4(vec3(m.x,o.z,m.z),d);
}



vec2 RM(vec3 ro, vec3 rd) {
    float dO = 0.;
    float ii = 0.;
    
    for (int i=0;i<220;i++) {
        vec3 p = ro+rd*dO;
        float dS = map(p).w;
        dO += dS*0.5;
        ii += 0.1;
        if (dS < 0.001 || dO > 1000.) {break;}
    }
    return vec2(dO,ii);
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = 1.- 2.*fragCoord/iResolution.xy;

    // Time varying pixel color
    //vec3 col = 0.5 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4));

    // Output to screen
    //fragColor = vec4(col,1.0);

    //vec2 uv = -1. + 2. * inData.v_texcoord;
    vec2 R = iResolution.xy;
    float ar = R.x/R.y;
    uv.x *= ar;
    vec3 col = vec3(0.);
    float c = length(uv*0.9);
    //uv *= r2d(c*4.+time);
    //uv *= r2d(uv.y*time*.1-time*4.3);
    vec3 ro = vec3(0.,0.,-0.5);
    //ro.z += time*0.2;
    vec3 rd = normalize(vec3(uv,1.));
    vec2 d = RM(ro,rd);
    vec3 p = ro+rd*d.x;
    vec3 pm = map(p).xyz;
    //col = sin(uv.xyy*39.);
    col = vec3((d.y*0.15)-0.3);
    col = (1.-d.yyy*0.1);
    //col -= d.y*0.3;
    vec3 hsv = vec3(
    sin(sin(pm.x*0.04+time*0.03)*4.)*2.+sin(pm.y*9.+pm.z*150.)*0.31,
    sin(pm.z*300.)*0.5+0.5,
    1.-d.y*0.1-d.x*0.4
    );
    if (d.x > 100.) {
        //hsv.y *= 0.2;
    }
    col = hsv2rgb(hsv);
    
    fragColor = vec4(col,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

